//package globalExamples;

import oracle.olapi.data.cursor.NoDataAvailableException;

import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.StringSource;
//import oracle.olapi.data.source.NumberSource;
import oracle.olapi.data.source.DataProvider;

import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mdm.MdmLevel;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension; 
import oracle.olapi.metadata.mdm.MdmAttribute;

/**
 * Complete code for Example 7-10, Drilling in a Hierarchy, in 
 * Chapter 7, Making Queries Using Source Methods, in the 
 * Oracle OLAP Developer's Guide to the  OLAP API.
 * 
 * This program uses the Context10g class, which uses the
 * CursorPrintWriter class.
 * 
 * @author Oracle Corporation
 */
public class DrillingInHierarchy 
{
  public DrillingInHierarchy()
  {
  }

  private void run(String[] args)
  {
    Context10g context = new Context10g(args);
    DataProvider dp = context.getDataProvider();

    context.println("Example 7-10, Drilling in a Hierarchy");
    
    MdmPrimaryDimension mdmProdDim = 
                             context.getMdmPrimaryDimensionByName("PRODUCT");
                             
    MdmLevelHierarchy mdmProdRollup = (MdmLevelHierarchy)
                                       mdmProdDim.getDefaultHierarchy();
    StringSource prodRollup =  (StringSource) mdmProdRollup.getSource();

    // Get the level.                                 
    //MdmLevel mdmLevel = context.getLevelByName(mdmProdRollup, "TOTAL_PRODUCT");
    //MdmLevel mdmLevel = context.getLevelByName(mdmProdRollup, "CLASS");
    MdmLevel mdmLevel = context.getLevelByName(mdmProdRollup, "FAMILY");
    //MdmLevel mdmLevel = context.getLevelByName(mdmProdRollup, "ITEM");
    
    Source levelSrc = mdmLevel.getSource();

    int pos = 2;
    //int pos = 1; // For total product
    Source levelElement = levelSrc.at(pos);

    // Use levelElement as the comparison to select a level value?
    Source levelSel = prodRollup.join(prodRollup.value(), levelElement);


    // Get the dimension's short label attribute.
    Source prodShortLabel = mdmProdDim.getShortValueDescriptionAttribute()
                                      .getSource();

    // Get the parent relation from the hierarchy.
    MdmAttribute mdmProdRollupParentAttr = mdmProdRollup.getParentAttribute();
    Source prodRollupParentAttr = mdmProdRollupParentAttr.getSource();

    // Get the ancestor relation from the hierarchy.
    MdmAttribute mdmProdRollupAncsAttr = mdmProdRollup.getAncestorsAttribute();
    Source prodRollupAncsAttr = mdmProdRollupAncsAttr.getSource();

    // Get the parent of the level element.
    Source levelElementParent = prodRollupParentAttr.join(prodRollup, levelElement);

    // Get ancestors of the level element.
    Source levelElementAncs = prodRollupAncsAttr.join(prodRollup, levelElement);

    // Reverse the parent relation to get a children relation.
    Source prodRollupChildren = prodRollup.join(prodRollupParentAttr, prodRollup.value());

    // Select the children of the specified level element.
    Source levelElementChildren = prodRollupChildren.join(prodRollup, 
                                                          levelElement);

    //Join the level to the short description attribute.
    Source levelSrcWithShortDescr = prodShortLabel.join(levelSrc);

    //Join the parent to the short description attribute.
    Source levelElementParentWithShortDescr = 
                     prodShortLabel.join(prodRollup, levelElementParent, true);

    //Join the children to the short description attribute.
    Source levelElementChildrenWithShortDescr = 
                                      prodShortLabel.join(levelElementChildren);
      
    //Join the ancestors to the short description attribute.
    Source levelElementAncsWithShortDescr = 
                       prodShortLabel.join(prodRollup, levelElementAncs, true);

    // Prepare and commit the current Transaction.
    context.commit();

    // Create Cursor objects and display their values.
    context.println("Level element values:");
    context.displayResult(levelSrcWithShortDescr); //(levelSrc);

    context.println("\nLevel element at position " + pos + ":");
    context.displayResult(levelElement);

    context.println("\nParent of the level element:");
    context.displayResult(levelElementParentWithShortDescr);

    context.println("\nChildren of the level element:");
    try
    {
      context.displayResult(levelElementChildrenWithShortDescr);
    }
    catch(NoDataAvailableException n)
    {
      context.println("This level element does not have any children. " + n);
    }

    context.println("\nAncestors of the level element:");
    context.displayResult(levelElementAncsWithShortDescr);
    
  }

  public static void main(String[] args)
  {
    new DrillingInHierarchy().run(args);
  }
}



